local my_db_path = db_path or "./scripts/database/"; dofile(my_db_path..'/scripts/GT.lua')
dofile(my_db_path..'/chassis/static.lua')

-- SA-3 S-125 TR
GT = {}
set_recursive_metatable(GT, GT_generic_stationary)
GT.chassis = chassis; chassis = nil

GT.visual.shape = "SNR-125"
GT.visual.shape_dstr = "SNR-125_p_1"

GT.id = 34628899

GT.sensor = {}
GT.sensor.max_range_finding_target = 100000
GT.sensor.min_range_finding_target = 1500
GT.sensor.max_alt_finding_target = 20000
--GT.sensor.cos_angle_visibility_target = 0.000796274
GT.sensor.height = 3

--Burning after hit
GT.visual.fire_size = 0.5 --relative burning size
GT.visual.fire_pos[1] = 0 -- center of burn at long axis shift(meters)
GT.visual.fire_pos[2] = 0 -- center of burn shift at vertical shift(meters)
GT.visual.fire_pos[3] = 0 -- center of burn at transverse axis shift(meters)
GT.visual.fire_time = 500 --burning time (seconds)

GT.WS = {}
GT.WS.maxTargetDetectionRange = 100000
GT.WS.radar_type = 103
GT.WS[inc_ws()] = {}
GT.WS[ws].newZ = true
GT.WS[ws].center = 'CENTER_TOWER'
GT.WS[ws].pos = {0,3,0}
GT.WS[ws].maxBottom = 0.0
GT.WS[ws].maxTop = math.rad(80)
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1
GT.WS[ws].omegaY = 0.174533
GT.WS[ws].omegaZ = 0.174533
GT.WS[ws].pidY = { p = 10, i = 2, d = 10}
GT.WS[ws].pidZ = { p = 10, i = 2, d = 10}
GT.WS[ws].reference_angle_Z = 0
GT.WS[ws].reference_angle_Y = 0


GT.WS[ws].LN = {}
GT.WS[ws].LN[1] = {}
GT.WS[ws].LN[1].type = 102
GT.WS[ws].LN[1].depends_on_unit = {34628898,}
GT.WS[ws].LN[1].distanceMin = 1500
GT.WS[ws].LN[1].distanceMax = 100000
GT.WS[ws].LN[1].min_trg_alt = 25
GT.WS[ws].LN[1].max_trg_alt = 20000
GT.WS[ws].LN[1].reactionTime = 6
GT.WS[ws].LN[1].reflection_limit = 0.18
GT.WS[ws].LN[1].max_number_of_missiles_channels = 2

GT.Sensors = { OPTIC = {"generic tank daysight", "human nightsight", "human daysight",}, RADAR = GT.Name, };

GT.CLSID = "{8CA1B264-74D2-4353-94FA-995F888D6C70}"
GT.name = "SA-3 SNR-125 TR"
GT.displayname = _("SAM SA-3 SNR-125 TR")
GT.score = 20

register_car(
  {
        CLSID = GT.CLSID,
        Name = GT.name,
        DisplayName = GT.displayname,
        DetectionRange  = GT.sensor.max_range_finding_target,
        ThreatRange = 0,
        Rate = GT.score,
        mapclasskey = "P0091000083",
  }, 
  {
    register_car_cat("{B84C5FC5-9893-45e4-A712-E3D4D201A003}", "SAM"),
  }
);

